#include "h/lcd5453.h"

// raw display buffer
unsigned char display[4];
//   order of raw digits
//       -6-  
//    5 |   | 7
//       -4-
//    3 |   | 1
//       -2-     o 0
//       
//

__attribute__((space(psv)))
const unsigned char ascii2RawConvert[256]=
{
// 0x00
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 0x10 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x20
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x30
0xEE, 0x82, 0xDC, 0xD6, 0xB2, 0x76, 0x7E, 0xC2, 0xFE, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x40
0x00, 0xFA, 0x3E, 0x6C, 0x9E, 0x7C, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x50
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x60
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x70
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x80
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0x90
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xA0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xB0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xC0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xD0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xE0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
// 0xF0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

void delayLCD(void)
{
	int i;
	for(i=0; i<80; i++)asm("nop");

}

void refreshLCD(void)
{
	int i;
	unsigned long current;

	current=(((unsigned long)display[3] & 0x80)>>7)|(((unsigned long)display[3] & 1)<<24)|(((unsigned long)display[3] & 0x0E))|(((unsigned long)display[3] & 0x70)<<25)|(((unsigned long)display[2] & 0x0F)<<4)|(((unsigned long)display[2] & 0xF0)<<21)|(((unsigned long)display[1] & 0x0F) << 8)|(((unsigned long)display[1] & 0xF0)<<16)|(((unsigned long)display[0] & 0xFF)<<12);
	LATBbits.LATB0=0;
	LATBbits.LATB1=1;
	delayLCD();
	LATBbits.LATB0=1;
	for(i=0; i<32; i++)
	{
	 LATBbits.LATB0=0;
	 if(current & 1)LATBbits.LATB1=1; else LATBbits.LATB1=0;
	 current=current>>1;
	 delayLCD();
	 LATBbits.LATB0=1;
	}
	for(i=0; i<3; i++)
	{
	LATBbits.LATB0=0;
	delayLCD();
	LATBbits.LATB0=1;
	}
}

void initLCD(void)
{
	TRISBbits.TRISB0=0;
	TRISBbits.TRISB1=0;
	LATBbits.LATB0=1;
	LATBbits.LATB1=1;
	display[0]=0;
	display[1]=0;
	display[2]=0;
	display[3]=0;
	refreshLCD();
}

void printASCIIAtPosition(unsigned char position, unsigned char ascii, unsigned char decp)
{
	decp&=1;
	display[position & 3]=ascii2RawConvert[ascii]+decp;
}

void disaLCD(unsigned char position, unsigned char value, unsigned char decp)
{
	printASCIIAtPosition(position, disFix(value>>4), 0);
	printASCIIAtPosition(position+1, disFix(value), decp);
	refreshLCD();
}
